﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.POS
{
    public partial class POSOrdering : System.Web.UI.Page
    {
        private static List<Products> pList;
        private static List<ProductCategory> pCategory;

        protected void Page_Load(object sender, EventArgs e)
        {
            // WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                LoadProducts(string.Empty);
            }
        }

        private void LoadProducts(string searchKeyword)
        {
            pList = ProductsBL.GetList(Guid.Empty, string.Empty);
            pList = (from p in pList
                     where (p.IsActive && p.IsMiscellaneous == false && searchKeyword == string.Empty || (p.ProductName.ToLower().Contains(searchKeyword.ToLower()) ||
                                                              p.ProductDescriptions.ToLower().Contains(searchKeyword.ToLower()) ||
                                                              p.ProductCode.ToLower().Contains(searchKeyword.ToLower()) ||
                                                              p.AdditionalInfo.ToLower().Contains(searchKeyword.ToLower()) ||
                                                              p.ProductCategoryID.ToString().ToLower().Contains(searchKeyword.ToLower()) ||
                                                              p.UnitPrice.ToString().ToLower().Contains(searchKeyword.ToLower())))
                     select p).ToList<Products>();
            rpProducts.DataSource = pList;
            rpProducts.DataBind();

            pCategory = ProductCategoryBL.GetList(Guid.Empty, string.Empty);
            if (pCategory != null && pCategory.Count > 0)
            {
                pCategory = pCategory.Where(a => a.IsActive).ToList<Entities.ProductCategory>();
            }
            rpCategories.DataSource = pCategory;
            rpCategories.DataBind();

        }



        protected void btnApplyDiscount_Click(object sender, EventArgs e)
        {
            lblDiscountError.Text = string.Empty;
            bool showPopup = false;
            if (ddlDiscountType.SelectedValue != "0")
            {
                if (ValidationUtility.ValidateDecimal(txtDiscountValue.Text.Trim()))
                {
                    if (ddlDiscountType.SelectedValue.Trim().ToLower().Equals("dollar"))
                    {
                        WebSession.CurrentPOSOrders.Discount = decimal.Parse(txtDiscountValue.Text.Trim());
                    }
                    else if (ddlDiscountType.SelectedValue.Trim().ToLower().Equals("percentage"))
                    {
                        WebSession.CurrentPOSOrders.Discount = WebSession.CurrentPOSOrders.SubTotal * decimal.Parse(txtDiscountValue.Text.Trim()) / 100;
                    }
                    showPopup = false;
                }
                else
                {
                    lblDiscountError.Text = "Please enter valid Discount";
                    txtDiscountValue.Focus();
                    showPopup = true;
                }
            }
            else
            {
                lblDiscountError.Text = "Please selet Discount Type";
                ddlDiscountType.Focus();
                showPopup = true;
            }

            if (showPopup)
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "$(function(){ $('#divDiscount').modal();});", true);
            }
        }

        protected void lnkProduct_Click(object sender, EventArgs e)
        {
            lblPError.Text = string.Empty;
            hdProductID.Value = string.Empty;
            LinkButton lnkProduct = (LinkButton)sender;
            if (lnkProduct != null)
            {
                hdProductID.Value = lnkProduct.CommandArgument.ToString();
                Guid productID = new Guid(hdProductID.Value);
                OrdersDetails myOD = WebSession.CurrentPOSOrders.OrdersDetailsList.Where(od => od.ProductID == productID).FirstOrDefault<OrdersDetails>();

                if (myOD != null)
                {
                    txtQty.Text = myOD.Quantity.ToString();
                    lblPrice.Text = myOD.OrderPrice.ToString("0.00");

                    ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "$(function(){ $('#divProduct').modal();});", true);
                }
            }
        }

        protected void btnUpdateProduct_Click(object sender, EventArgs e)
        {
            bool showPopup = false;
            if (ValidationUtility.ValidateInt(txtQty.Text.Trim()) && int.Parse(txtQty.Text.Trim()) > 0)
            {
                // if (ValidationUtility.ValidateDecimal(txtPrice.Text.Trim()))
                // {
                if (hdProductID.Value.Trim().Length != 0)
                {
                    string remarks = string.Empty;
                    Guid productID = new Guid(hdProductID.Value);
                    Products curProduct = ProductsBL.GetItem(productID, string.Empty);
                    WebSession.AddProductToCart(WebSession.CurrentOrders, curProduct, curProduct.UnitPrice, int.Parse(txtQty.Text.Trim()), true);
                    lblPError.Text = hdProductID.Value = txtQty.Text = lblPrice.Text = string.Empty;
                }
                showPopup = false;
                // }
                // else
                // {
                //     lblPError.Text = "Please enter valid Price";
                //    txtPrice.Focus();
                //    showPopup = true;
                // }
            }
            else
            {
                lblPError.Text = "Please enter valid Quantity";
                txtQty.Focus();
                showPopup = true;
            }
            if (showPopup)
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "$(function(){ $('#divProduct').modal();});", true);
            }
        }

        #region Add Payment & Save Order
        protected void lnkPay_Click(object sender, EventArgs e)
        {
            lblPayError.Text = string.Empty;
            if (WebSession.CurrentPOSOrders != null && WebSession.CurrentPOSOrders.OrdersDetailsList.Count > 0)
            {
                lblPayTotal.Text = WebSession.CurrentPOSOrders.Total.ToString("SGD 0.00");
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "$(function(){ $('#divPayment').modal();});", true);
            }
            else
                WebUtilities.ShowMessage(this, "You must add any item to make order");
        }

        protected void btnSaveOrder_Click(object sender, EventArgs e)
        {
            bool showPopup = false;
            if (ddlPayMethod.SelectedValue != "0")
            {
                if (ValidationUtility.ValidateDecimal(txtPaidAmount.Text.Trim()))
                {
                    decimal paid = 0;
                    decimal.TryParse(txtPaidAmount.Text.Trim(), out paid);

                    WebSession.CurrentPOSOrders.PaidAmount = paid;
                    WebSession.CurrentPOSOrders.AdminUserAccountID = (WebSession.CurrentAdminUser != null ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty);
                    WebSession.CurrentPOSOrders.IsShipToBillingAddress = true;
                    WebSession.CurrentPOSOrders.OrderFrom = WebSession.OrdersFrom;
                    WebSession.CurrentPOSOrders.PaymentMethod = ddlPayMethod.SelectedValue;
                    WebSession.CurrentPOSOrders.PaymentType = txtBankName.Text.Trim();
                    WebSession.CurrentPOSOrders.TransactionReference = txtReferenceNo.Text.Trim();
                    WebSession.CurrentPOSOrders.PaymentStatus = (WebSession.CurrentPOSOrders.PaidAmount >= WebSession.CurrentPOSOrders.Total) ? "Completed" : "Pending";
                    WebSession.CurrentPOSOrders.OrderStatus = "New";

                    int days = WebSession.CurrentPOSOrders.OrdersDetailsList.Max(i => i.EarliestAvailableDays);
                    WebSession.CurrentPOSOrders.EarliestAvailableDate = DateTime.Now.AddDays(days);

                    if (OrdersBL.Save(WebSession.CurrentPOSOrders))
                    {
                        WebSession.CurrentPOSOrders = OrdersBL.GetItem(WebSession.CurrentPOSOrders.UniqueID, Guid.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);
                        WebSession.UpdateOrderProductQty(WebSession.CurrentPOSOrders);
                        OrdersBL.GenerateInvoice(WebSession.CurrentPOSOrders.UniqueID);

                        //print invoice
                        WebUtilities.RegisterScript(this, "OpenPopUp('" + this.ResolveClientUrl("~/Admin/POS/PrintInvoice.aspx?UniqueID=" + WebSession.CurrentPOSOrders.UniqueID) + "');");
                        WebSession.CurrentPOSOrders = null;
                        ddlPayMethod.SelectedIndex = -1;
                        lblPayError.Text = lblPayTotal.Text = txtPaidAmount.Text = txtBankName.Text = txtReferenceNo.Text = string.Empty;
                    }

                    showPopup = false;
                }
                else
                {
                    lblPayError.Text = "Please enter valid Price";
                    lblPrice.Focus();
                    showPopup = true;
                }
            }
            else
            {
                lblPayError.Text = "Please select valid Payment Method";
                ddlPayMethod.Focus();
                showPopup = true;
            }

            if (showPopup)
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "$(function(){ $('#divPayment').modal();});", true);
            }
        }
        #endregion

    }
}